#version 100

//ZMAO SHADER V4 beta

/*
                           
                    ██████████████
                    ██████████████
                    ██████████████
                    ██████████████
                    █▒▒▒▒████▒▒▒▒█
                    ██████████████
                    ██████████████
                    ██████████████

*/

//Copyright © ZMAO
//ZMAO Source

const bool wavyWater = true;
const bool waterShadows = true;
const bool normalWaterColor = true;
const bool enderWaterColor = true;

uniform MAT4 WORLDVIEWPROJ;
uniform vec4 FOG_COLOR;
uniform vec2 FOG_CONTROL;
uniform float RENDER_DISTANCE;
uniform vec2 VIEWPORT_DIMENSION;
uniform vec4 CURRENT_COLOR;		
uniform POS3 CHUNK_ORIGIN;
uniform POS3 VIEW_POS;
uniform float FAR_CHUNKS_DISTANCE;

attribute POS4 POSITION;
attribute vec4 COLOR;
attribute vec2 TEXCOORD_0;
attribute vec2 TEXCOORD_1;
uniform highp float TIME;
uniform sampler2D TEXTURE_0;
uniform sampler2D TEXTURE_1;

uniform sampler2D s_texture;

varying vec2 uv0;
varying vec2 uv1;
varying vec4 color;

varying vec2 v_texCoord;
varying vec2 v_blurTexCoords[14];

#ifdef FOG
	varying vec4 fogColor;
#endif

const float rA = 2.0; 
const float rB = 2.0; 
vec3 UNIT_Y = vec3(0,1.43,0);
const float DIST_DESATURATION = 0.2196078;

void main()
{
    POS4 pos = WORLDVIEWPROJ * POSITION;
    gl_Position = pos;

    uv0 = TEXCOORD_0;
    uv1 = TEXCOORD_1;
	   color = COLOR;

//// find distance from the camera

#if defined(FOG) || defined(NEAR_WATER)
		#ifdef FANCY
		vec3 relPos = VIEW_POS - (POSITION.xyz + CHUNK_ORIGIN);
		float cameraDepth = length(relPos);
	#else
		float cameraDepth = pos.z;
	#endif
#endif

#ifdef ALPHA_TEST ///// normal dismiss
#ifdef FANCY ///// is fancy

if(color.g + color.r > color.b + color.b && abs(color.g - color.r) < 9.0)
{
 vec3 wav = POSITION.xyz + CHUNK_ORIGIN;

//Wavy leaves and grass and flower 

const float wavyleaves = 14.8;

 gl_Position.x += cos(TIME+((wav.y+wav.y + wav.x)*cos(wav.y)))/wavyleaves;
 gl_Position.y +=  cos(TIME+((wav.y+wav.y + wav.x)*cos(wav.y)))/wavyleaves;

//sin(TIME+(wav.xxy*sin(wav.z)))/500.8 - 1.05;
}
#endif
#endif

///// apply fog

#ifdef FOG
	float len = cameraDepth / RENDER_DISTANCE;
	#ifdef ALLOW_FADE
		len += CURRENT_COLOR.r;
	#endif
  fogColor.rgb = FOG_COLOR.rgb;
	fogColor.a = clamp((len - FOG_CONTROL.x) + (FOG_CONTROL.y - FOG_CONTROL.x), 0.0, 1.0);
#endif

///// water magic

///// water magic
#ifdef NEAR_WATER
	#ifdef FANCY  /////enhance water

		float F = dot(normalize(relPos), UNIT_Y);
   //F = dot(normalize(relPos), unit_mx);;
		//if both NEAR_WATER and FOG are defined, it's forced fog and we're underwater

		#ifndef FOG  //over water
		 F = 0.0 - max(F, -0.1);
		#else //under water
			color.a = 0.0; //disable fake transparency and be transparent
		#endif

//fogColor.rgb = FOG_COLOR.rgb;

		F = 1.0 - mix(F*F*F*F, 1.0, min(1.0, cameraDepth / FAR_CHUNKS_DISTANCE));

		color.rg -= vec2(F * DIST_DESATURATION);

		vec4 depthColor = vec4(color.rgb * 0.5, 4.0);
		vec4 traspColor = vec4(color.rgb * 0.45, 0.8);
		vec4 surfColor = vec4(color.rgb, 1.0);
		vec4 nearColor = mix(traspColor, depthColor, color.a);
   vec4 skyDay = vec4 ( 0.0, 0.3, 0.6, 1.0);
   vec4 ender = vec4 (0.6,0.9,1.0,1.0);

	if (enderWaterColor) {
color = ender * nearColor *surfColor;
}

	if (normalWaterColor) {
color = mix(surfColor, nearColor, F);
}


vec4 light = texture2D( TEXTURE_1, uv1 );
vec4 tex = texture2D( TEXTURE_0, uv0);

vec3 wav = POSITION.xyz + CHUNK_ORIGIN;

//Wavy water speed
const float waterspeed = 5.5;

//Wavy shadows speed
const float shadowspeed = 16.2;
const float shadowspeed2 = 18.14159265358;

//Wav multipler
const float wavwater = 30.0;
const float wavshadowsy = 70.0;
const float wavshadowsx = 70.0;


//This code set pos for water wavs dont touch
const float wavspeed = 1.0;
const float PII = 3.14159265358979323846264;

//Wavy Water 

	const float waveHeight 		= 0.34;
	const float waveSpeed		= 1.141569;
	const float waveResolution	= 5.0;

	if (wavyWater) {
	gl_Position.y += waveHeight * sin(TIME * waveSpeed + wav.x);
	gl_Position.y += waveHeight * cos(TIME * waveSpeed + wav.z);
}

//Wavy shadows extras
	if (waterShadows) {
color.rgb +=cos(TIME * shadowspeed2+((wav.x+wav.x+wav.y+wav.z+wav.x+wav.y+wav.y+wav.z+wav.x+wav.y+wav.z +wav.z)*cos(wav.y)))/wavshadowsx;

//Wavy shadow normal
color.rgb += cos(TIME * shadowspeed+((wav.x-wav.y+wav.y-wav.z+wav.y-wav.y+wav.x-wav.y-wav.y+wav.z+wav.y-wav.y+wav.x-wav.y+wav.y+wav.z-wav.y+wav.y)*cos(wav.z)))/wavshadowsy;
}
//sin(TIME+(wav.xxy*sin(wav.z)))/500.8 - 0.05;

#else
		color.a = pos.z / FAR_CHUNKS_DISTANCE;
	#endif //FANCY
#else
color.b *= 0.78;
color = min(vec4(color.rgb * 1.0, 1.0), 1.0);
color.b *= 2.0;
#endif
}


